unit ZoneAlarmU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Registry, Grids, ExtCtrls;

const
  MainKey = '\SOFTWARE\Zone Labs\TrueVector\LocalStoreDir';

type
  PR_IP = ^TR_IP;
  TR_IP = record
    IP1, IP2, IP3, IP4, Port: integer;
  end;
  PR_IPm = ^TR_IPm;
  TR_IPm = record
    IP1, IP2, IP3, IP4, Port, Mult: integer;
  end;

  TF_Zone = class(TForm)
    B_Exit: TButton;
    E_Count: TEdit;
    S_IP: TStringGrid;
    Label3: TLabel;
    B_IP: TButton;
    B_Port: TButton;
    B_Mult: TButton;
    E_Files: TEdit;
    Label1: TLabel;
    B_ExportAll: TButton;
    SaveDialog1: TSaveDialog;
    B_Export_Port: TButton;
    B_Export_Mult: TButton;
    B_Export_Port_Mult: TButton;
    Panel1: TPanel;
    M_HTML: TMemo;
    M_HTML_in: TMemo;
    M_HTML_end: TMemo;
    procedure FormActivate(Sender: TObject);
    procedure B_ExitClick(Sender: TObject);
    procedure B_GetIPsClick(Sender: TObject);
    procedure B_Get_IPsClick(Sender: TObject);
    procedure S_IPClick(Sender: TObject);
    procedure B_IPClick(Sender: TObject);
    procedure B_PortClick(Sender: TObject);
    procedure B_MultClick(Sender: TObject);
    procedure B_ExportAllClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  F_Zone: TF_Zone;
  Location : string;
  L_IP, L_IPm : TList;
  Count2 : integer;

implementation

{$R *.DFM}

procedure TF_Zone.FormActivate(Sender: TObject);
var
  Reg : TRegistry;
  s : string;
begin
  Reg := TRegistry.Create;
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  if Reg.OpenKey(MainKey, True) then
  Location := Reg.ReadString('')
  else ShowMessage('Failure to open Registry');
  Reg.CloseKey;
  if Length(Location) < 1 then ShowMessage('Failure to get Location-name');
  Reg.Free;
  S_IP.ColWidths[0] := 25;
  S_IP.ColWidths[1] := 105;
  S_IP.ColWidths[2] := 50;
  S_IP.ColWidths[3] := 60;
  S_IP.Cells[1,0] := 'IP-address Intruder';
  S_IP.Cells[2,0] := 'Port';
  S_IP.Cells[3,0] := 'Multiplicity';
  L_IP := TList.Create;
  L_IPm := TList.Create;
  B_GetIPsClick(Sender);
end;

procedure TF_Zone.B_ExitClick(Sender: TObject);
begin
  Close;
end;

//sorteren op IP
function TListSortCompareIP(Item1, Item2: Pointer): Integer;
var
  I1, I2 : PR_IP;
begin
  I1 := Item1;
  I2 := Item2;
  if (I1^.IP1 > I2^.IP1) OR ((I1^.IP1 = I2^.IP1) AND (I1^.IP2 > I2^.IP2)) OR
     ((I1^.IP1 = I2^.IP1) AND (I1^.IP2 = I2^.IP2) AND (I1^.IP3 > I2^.IP3)) OR
     ((I1^.IP1 = I2^.IP1) AND (I1^.IP2 = I2^.IP2) AND (I1^.IP3 = I2^.IP3) AND (I1^.IP4 > I2^.IP4)) OR
     ((I1^.IP1 = I2^.IP1) AND (I1^.IP2 = I2^.IP2) AND (I1^.IP3 = I2^.IP3) AND (I1^.IP4 = I2^.IP4) AND (I1^.PORT < I2^.PORT))
  then TListSortCompareIP := 1
  else
  if (I1^.IP1 = I2^.IP1) AND (I1^.IP2 = I2^.IP2) AND (I1^.IP3 = I2^.IP3) AND (I1^.IP4 = I2^.IP4) AND (I1^.PORT = I2^.PORT)
  then TListSortCompareIP := 0
  else TListSortCompareIP := -1;
end;

//sorteren op IP
function TListSortCompareIPm(Item1, Item2: Pointer): Integer;
var
  I1, I2 : PR_IPm;
begin
  I1 := Item1;
  I2 := Item2;
  if (I1^.IP1 > I2^.IP1) OR ((I1^.IP1 = I2^.IP1) AND (I1^.IP2 > I2^.IP2)) OR
     ((I1^.IP1 = I2^.IP1) AND (I1^.IP2 = I2^.IP2) AND (I1^.IP3 > I2^.IP3)) OR
     ((I1^.IP1 = I2^.IP1) AND (I1^.IP2 = I2^.IP2) AND (I1^.IP3 = I2^.IP3) AND (I1^.IP4 > I2^.IP4))
  then TListSortCompareIPm := 1
  else
  if (I1^.IP1 = I2^.IP1) AND (I1^.IP2 = I2^.IP2) AND (I1^.IP3 = I2^.IP3) AND (I1^.IP4 = I2^.IP4)
  then TListSortCompareIPm := 0
  else TListSortCompareIPm := -1;
end;

//sorteren op PORT
function TListSortComparePort(Item1, Item2: Pointer): Integer;
var
  I1, I2 : PR_IPm;
begin
  I1 := Item1;
  I2 := Item2;
  if I1^.PORT < I2^.PORT then TListSortComparePORT := 1
  else if I1^.PORT = I2^.PORT then TListSortComparePORT := 0
  else TListSortComparePORT := -1;
end;

//sorteren op Mult
function TListSortCompareMult(Item1, Item2: Pointer): Integer;
var
  I1, I2 : PR_IPm;
begin
  I1 := Item1;
  I2 := Item2;
  if I1^.Mult < I2^.Mult then TListSortCompareMult := 1
  else if I1^.Mult = I2^.Mult then TListSortCompareMult := 0
  else TListSortCompareMult := -1;
end;

procedure TF_Zone.B_GetIPsClick(Sender: TObject);
var
  Result, Count, FCount, P, i, lIP1, lIP2, lIP3, lIP4, lPort: Integer;
  SearchRec: TSearchRec;
  filename, s, t : string;
  Fin : TextFile;
  IP : PR_IP;
  IPm : PR_IPm;
begin
  Count := 0;
  FCount := 0;
  Count2 := 0;
  ChDir(Location);
  Result:= FindFirst('ZALog*.txt', faArchive, SearchRec);
  if Result = 0 then
  begin
    while Result = 0 do
    begin
      s := SearchRec.Name;
      inc(FCount);
      filename := Location + '\' + s;
      AssignFile(Fin, filename);
      {$I-}
      Reset(Fin);
      {$I+}
      if IOResult = 0 then
      begin
        readln(Fin, t);
        readln(Fin, t);
        readln(Fin, t);
        while not eof(Fin) do
        begin
          readln(Fin, t);
          if Pos('FWIN', T) = 1 then
          begin
            inc(Count);
            new(IP);
            with IP^ do
            begin
              P := Pos('GMT,', T);
              t := Copy(T, P+4, Length(T) - P - 3);
              P := Pos('.', t);
              IP1 := StrToInt(Copy(t, 1, P-1));
              t := Copy(T, P+1, Length(T) - P);
              P := Pos('.', t);
              IP2 := StrToInt(Copy(t, 1, P-1));
              t := Copy(T, P+1, Length(T) - P);
              P := Pos('.', t);
              IP3 := StrToInt(Copy(t, 1, P-1));
              t := Copy(T, P+1, Length(T) - P);
              P := Pos(':', t);
              IP4 := StrToInt(Copy(t, 1, P-1));
              t := Copy(t, P+1, Length(t) - P);
              P := Pos(':', T);
              t := Copy(T, P+1, Length(T) - P);
              P := Pos(',', t);
              Port := StrToInt(Copy(t, 1, P-1));
              L_IP.Add(IP);
            end;
          end;
        end;
      end;
      Result:= FindNext(SearchRec);
    end;
    FindClose(SearchRec);
  end
  else ShowMessage('Failure to find ZALog-files');
  E_Files.Text := IntToStr(FCount);
  E_Count.Text := IntToStr(Count);
  L_IP.Sort(TListSortCompareIP);
  lIP1 := 0;
  lIP2 := 0;
  lIP3 := 0;
  lIP4 := 0;
  lPort := 10000000;
  for i := 0 to Count - 1 do
  begin
    IP := L_IP[i];
    if (IP^.IP1 > lIP1) OR (IP^.IP2 > lIP2) OR (IP^.IP3 > lIP3) OR (IP^.IP4 > lIP4) OR (IP^.PORT < lPORT)
    then
    begin
      if i > 0 then L_IPm.Add(IPm);
      lIP1 := IP^.IP1;
      lIP2 := IP^.IP2;
      lIP3 := IP^.IP3;
      lIP4 := IP^.IP4;
      lPort := IP^.PORT;
      IPm := new(PR_IPm);
      IPm^.IP1 := IP^.IP1;
      IPm^.IP2 := IP^.IP2;
      IPm^.IP3 := IP^.IP3;
      IPm^.IP4 := IP^.IP4;
      IPm^.PORT := IP^.PORT;
      IPm^.mult := 1;
      inc(count2);
    end
    else IPm^.mult := IPm^.mult + 1;
  end;
  L_IPm.Add(IPm);
  S_IP.RowCount := Count2+1;
  for i := 0 to Count2 - 1 do
  begin
    IPm := L_IPm[i];
    with IPm^ do
    begin
      S_IP.Cells[0,i+1] := IntToStr(i+1);
      S_IP.Cells[1,i+1] := IntToStr(IP1)+'.'+IntToStr(IP2)+'.'+IntToStr(IP3)+'.'+IntToStr(IP4);
      S_IP.Cells[2,i+1] := IntToStr(Port);
      S_IP.Cells[3,i+1] := IntToStr(Mult);
    end;
  end;
end;

procedure TF_Zone.B_Get_IPsClick(Sender: TObject);
begin
  //AssignFile
  //L_File.Items.Add(DirSearcher1.Filename);
end;

procedure TF_Zone.S_IPClick(Sender: TObject);
begin
  ShowMessage('OK');
end;

procedure TF_Zone.B_IPClick(Sender: TObject);
var
  i : integer;
  IPm : PR_IPm;
begin
  L_IPm.Sort(TListSortCompareIPm);
  for i := 0 to Count2 - 1 do
  begin
    IPm := L_IPm[i];
    with IPm^ do
    begin
      S_IP.Cells[0,i+1] := IntToStr(i+1);
      S_IP.Cells[1,i+1] := IntToStr(IP1)+'.'+IntToStr(IP2)+'.'+IntToStr(IP3)+'.'+IntToStr(IP4);
      S_IP.Cells[2,i+1] := IntToStr(Port);
      S_IP.Cells[3,i+1] := IntToStr(Mult);
    end;
  end;
end;

procedure TF_Zone.B_PortClick(Sender: TObject);
var
  i : integer;
  IPm : PR_IPm;
begin
  L_IPm.Sort(TListSortComparePort);
  for i := 0 to Count2 - 1 do
  begin
    IPm := L_IPm[i];
    with IPm^ do
    begin
      S_IP.Cells[0,i+1] := IntToStr(i+1);
      S_IP.Cells[1,i+1] := IntToStr(IP1)+'.'+IntToStr(IP2)+'.'+IntToStr(IP3)+'.'+IntToStr(IP4);
      S_IP.Cells[2,i+1] := IntToStr(Port);
      S_IP.Cells[3,i+1] := IntToStr(Mult);
    end;
  end;
end;

procedure TF_Zone.B_MultClick(Sender: TObject);
var
  i : integer;
  IPm : PR_IPm;
begin
  L_IPm.Sort(TListSortCompareMult);
  for i := 0 to Count2 - 1 do
  begin
    IPm := L_IPm[i];
    with IPm^ do
    begin
      S_IP.Cells[0,i+1] := IntToStr(i+1);
      S_IP.Cells[1,i+1] := IntToStr(IP1)+'.'+IntToStr(IP2)+'.'+IntToStr(IP3)+'.'+IntToStr(IP4);
      S_IP.Cells[2,i+1] := IntToStr(Port);
      S_IP.Cells[3,i+1] := IntToStr(Mult);
    end;
  end;
end;

procedure TF_Zone.B_ExportAllClick(Sender: TObject);
var
  i, t, c : integer;
  IPm : PR_IPm;
begin
  if SaveDialog1.execute then
  begin
    t := (Sender as TButton).Tag;
    c := 0;
    M_HTML.Clear;
    M_HTML.Lines.AddStrings(M_HTML_in.Lines);
    for i := 0 to Count2-1 do
    begin
      IPm := L_IPm[i];
      with IPm^ do
      begin
        if (t = 0) OR ((t = 1) AND (Port > 0)) OR ((t = 2) AND (Mult > 1)) OR ((t = 3) AND (Port > 0) AND (Mult > 1))
        then
        begin
          inc(c);
          M_HTML.Lines.Add(' <TR>');
          M_HTML.Lines.Add('  <TD assign=right>'+IntToStr(c)+'</TD>');
          M_HTML.Lines.Add('  <TD>'+IntToStr(IP1)+'.'+IntToStr(IP2)+'.'+IntToStr(IP3)+'.'+IntToStr(IP4)+'</TD>');
          M_HTML.Lines.Add('  <TD assign=right>'+IntToStr(Port)+'</TD>');
          M_HTML.Lines.Add('  <TD assign=right>'+IntToStr(Mult)+'</TD>');
          M_HTML.Lines.Add(' </TR>');
        end;
      end;
    end;
    M_HTML.Lines.AddStrings(M_HTML_end.Lines);
    M_HTML.Lines.SaveToFile(SaveDialog1.filename);
  end;
end;

end.
